% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitting_basic.R
\name{fit,tscopulaU-method}
\alias{fit,tscopulaU-method}
\title{Fit method for tscopulaU class}
\usage{
\S4method{fit}{tscopulaU}(x, y, tsoptions = list(), control = list())
}
\arguments{
\item{x}{an object of class \linkS4class{tscopulaU}.}

\item{y}{vector or time series of data to which the copula process is to be fitted.}

\item{tsoptions}{list of options}

\item{control}{list of control parameters to be passed to the
\code{\link[stats]{optim}} function.}
}
\value{
An object of class \linkS4class{tscopulafit}.
}
\description{
Fit method for tscopulaU class
}
\examples{
data <- sim(armacopula(list(ar = 0.5, ma = 0.4)), n = 1000)
fit(armacopula(list(ar = 0.5, ma = 0.4)), data)
}
