% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_pc.R
\name{ts_pc}
\alias{ts_pc}
\alias{ts_diff}
\alias{ts_pca}
\alias{ts_pcy}
\alias{ts_diffy}
\title{First Differences and Percentage Change Rates}
\usage{
ts_pc(x)

ts_diff(x)

ts_pca(x)

ts_pcy(x)

ts_diffy(x)
}
\arguments{
\item{x}{ts-boxable time series, an object of class \code{ts}, \code{xts}, \code{zoo},
\code{data.frame}, \code{data.table}, \code{tbl}, \code{tbl_ts}, \code{tbl_time}, \code{tis}, \code{irts} or
\code{timeSeries}.}
}
\value{
a ts-boxable time series, with the same class as the input.
}
\description{
\code{ts_pcy} and \code{ts_diffy} calculate the percentage change rate and the
difference compared to the previous period, \code{ts_pcy} and \code{ts_diffy} calculate
the percentage change rate compared to the same period of the previous year.
\code{ts_pca} calculates annualized percentage change rates compared to the
previous period.
}
\examples{
tail(ts_diff(ts_c(fdeaths, mdeaths)))
tail(ts_pc(ts_c(fdeaths, mdeaths)))
tail(ts_pca(ts_c(fdeaths, mdeaths)))
tail(ts_pcy(ts_c(fdeaths, mdeaths)))
tail(ts_diffy(ts_c(fdeaths, mdeaths)))
}
