% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayesian-heads-cts.R
\name{dist_quantile}
\alias{dist_quantile}
\title{Find quantiles given a probability density function}
\usage{
dist_quantile(dist, probs, bounds = attr(dist, "limits"))
}
\arguments{
\item{dist}{A one argument function}

\item{probs}{A vector of probabilities}

\item{bounds}{A length 2 vector of the bounds of the distribution's support}
}
\value{
A vector of quantiles
}
\description{
Find quantiles given a probability density function
}
\examples{

d1 <- update_prior(33, 50, P = 0.5, prior = stats::dunif)
dist_quantile(d1, c(0.025, 0.975))

}
