% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resampling.R, R/triptych_murphy.R,
%   R/triptych_reliability.R, R/triptych_roc.R
\name{resampling_Bernoulli}
\alias{resampling_Bernoulli}
\alias{resampling_Bernoulli.triptych_murphy}
\alias{resampling_Bernoulli.triptych_reliability}
\alias{resampling_Bernoulli.triptych_roc}
\title{Bootstrap (binary) observation resampling for triptych objects}
\usage{
resampling_Bernoulli(x, level = 0.9, n_boot = 1000, ...)

\method{resampling_Bernoulli}{triptych_murphy}(x, level = 0.9, n_boot = 1000, ...)

\method{resampling_Bernoulli}{triptych_reliability}(
  x,
  level = 0.9,
  n_boot = 1000,
  position = c("diagonal", "estimate"),
  ...
)

\method{resampling_Bernoulli}{triptych_roc}(x, level = 0.9, n_boot = 1000, ...)
}
\arguments{
\item{x}{One of the triptych objects.}

\item{level}{A single value that determines which quantiles of
the bootstrap sample to return. These quantiles envelop \code{level * n_boot}
bootstrap draws.}

\item{n_boot}{The number of bootstrap samples.}

\item{...}{Additional arguments passed to other methods.}

\item{position}{Either \code{"estimate"} for confidence regions, or \code{"diagonal"}
for consistency regions.}
}
\value{
A list of tibbles that contain the information to draw confidence regions.
The length is equal to the number of forecasting methods in \code{x}.
}
\description{
This function is intended to be called from \code{\link[=add_consistency]{add_consistency()}} or \code{\link[=add_confidence]{add_confidence()}},
by specifying \code{"resampling_Bernoulli"} in the respective \code{method} argument.
}
\details{
Bootstrap (binary) observation resampling assumes conditionally independent observations given the forecast value.
A given number of bootstrap samples are the basis for pointwise computed confidence/consistency intervals.
For every bootstrap sample, we sample observations from a Bernoulli distribution conditional on (recalibrated) forecast values.
}
\examples{
data(ex_binary, package = "triptych")

# Bootstrap resampling is expensive
# (the number of bootstrap samples is small to keep execution times short)

tr_consistency <- triptych(ex_binary) |>
  dplyr::slice(1, 9) |>
  add_consistency(level = 0.9, method = "resampling_Bernoulli", n_boot = 20)

tr_confidence <- triptych(ex_binary) |>
  dplyr::slice(1, 9) |>
  add_confidence(level = 0.9, method = "resampling_Bernoulli", n_boot = 20)

}
