% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutators.R
\name{add_confidence}
\alias{add_confidence}
\title{Adding confidence regions}
\usage{
add_confidence(x, level = 0.9, method = "resampling_cases", ...)
}
\arguments{
\item{x}{An object to which a confidence region should be added.}

\item{level}{A single value for the level of confidence.}

\item{method}{A string that gives the name of method to generate the confidence regions. Currently, one of: "resampling_cases", "resampling_Bernoulli".}

\item{...}{Additional arguments passed to methods.}
}
\value{
The object given to \code{x}, but with information about the confidence regions.
This information can be accessed conveniently by using \code{\link[=regions]{regions()}} on the
curve component of interest.
}
\description{
Confidence regions are supposed to contain the true "parameter" with a given degree of confidence.
Here, "parameter" refers to a murphy curve, a reliability curve, or a ROC curve, respectively.
}
\examples{
data(ex_binary, package = "triptych")

tr <- triptych(ex_binary) |>
  dplyr::slice(1, 9)

# Bootstrap resampling is expensive
# (the number of bootstrap samples is small to keep execution times short)

tr <- add_confidence(tr, level = 0.9, method = "resampling_cases", n_boot = 20)
regions(tr$murphy)
regions(tr$reliability)
regions(tr$roc)

}
\seealso{
\code{\link[=resampling_cases]{resampling_cases()}}, \code{\link[=resampling_Bernoulli]{resampling_Bernoulli()}}
}
