% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trinROC.test.R
\name{trinROC.test}
\alias{trinROC.test}
\title{Trinormal based ROC test}
\usage{
trinROC.test(
  x1,
  y1,
  z1,
  x2 = 0,
  y2 = 0,
  z2 = 0,
  dat = NULL,
  paired = FALSE,
  conf.level = 0.95
)
}
\arguments{
\item{x1, y1, z1}{(non-empty) numeric vectors of data from the healthy,
intermediate and diseased class from Classifier 1.}

\item{x2, y2, z2}{numeric vectors of data from the healthy, intermediate and
diseased class from Classifier 2.}

\item{dat}{a data frame of the following structure: The first column
represents a factor with three levels, containing the true class membership
of each measurement. The levels are ordered according to the convention of
higher values for more severe disease status. The second column contains
all measurements obtained from Classifier 1 (in the case of single marker
assessment). In the case of comparison of two markers, column three
contains the measurementss from the Classifier.}

\item{paired}{a logical indicating whether data arose from a paired setting.
If \code{TRUE}, each class must have equal sample size for both
classifiers.}

\item{conf.level}{confidence level of the interval. A numeric value between (0,1)
yielding the significance level \eqn{\alpha=1-\code{conf.level}}.}
}
\value{
A list of class \code{"htest"} containing the following components:
  \item{statistic}{the value of the chi-squared statistic.}
  \item{parameter}{the degrees of freedom for the chi-squared statistic.}
  \item{p.value}{the p-value for the test.}
  \item{conf.int}{a confidence interval for the test.}
  \item{estimate}{a data frame containing the estimated VUS and parameters
  a, b, c and d from Classifier 1 and Classifier 2 (if specified).}
  \item{null.value}{a character expressing the null hypothesis.}
  \item{alternative}{a character string describing the alternative hypothesis.}
  \item{method}{a character string indicating what
  type of trinormal based ROC test was performed.}
  \item{data.name}{a character string giving the names of the data.}
  \item{CovMat}{the covariance matrix of the chi-squared statistic.}
  \item{Summary}{a data frame representing the number of NA's as well as
  the means and the standard deviations per class.}
}
\description{
A statistical test function to assess three-class ROC data. It is possible to
investigate a single classifier or make a comparison of two independent /
correlated classifiers.
}
\details{
The trinormal ROC model is a parametric model in three-class ROC
analysis. It is based on normality in each of the trhee classes D_-
(healthy), D_0 (intermediate) and D_+ (diseased) with denoted distributions
\eqn{N(\mu_-,\sigma_-^2)}, \eqn{N(\mu_0,\sigma_0^2)} and
\eqn{N(\mu_+,\sigma_+^2)}. A classifier of a trinormal ROC model classifies
individuals into one of the three ordered classes based on two cut-off points
\eqn{c_- < c_+}. We define \eqn{t_-=F_-(c_-)} and \eqn{t_+
=1-F_+(c_+)=G_+(c_+)}. Now, the ROC surface can be written as

\deqn{ROCs(t_-,t_+) = \Phi \left(\frac{\Phi^{-1} (1-t_+) +d}{c} \right) -
\Phi \left(\frac{\Phi^{-1} (t_-)+b}{a} \right)}

whith parameters a, b, c and c given by \eqn{a =
\frac{\hat{\sigma}_0}{\hat{\sigma}_-}, b = \frac{ \hat{\mu}_- -
\hat{\mu}_0}{\hat{\sigma}_-}, c = \frac{\hat{\sigma}_0}{\hat{\sigma}_+}, d =
\frac{ \hat{\mu}_+ - \hat{\mu}_0}{\hat{\sigma}_+} }. It is a surface in the
unit cube that plots the probability of a measurement to get assigned to the
intermediate class as the two thresholds \eqn{c_-,c_+} are varying.

Based on the reference standard, the trinormal based ROC test can be used
to assess the discriminatory power of such classifiers. It distinguishes
between single classifier assessment, where a classifier is compared to some
hypothetical distributions in the classes, and comparison between two
classifiers. The latter case tests for equality between the parameters a, b,
c and d of the ROC curves. The data can arise in a unpaired or paired
setting. If \code{paired} is \code{TRUE}, a correlation is introduced which
has to be taken into account. Therefore the sets of the two classifiers have
to have classwise equal size. The data can be input as the data frame
\code{dat} or as single vectors \code{x1, y1, z1, ...}.

As the Chi-squared test is by definition a one-sided test, the variable
\code{alternative} cannot be specified in this test. For this 'goodness of
fit' test, we assume the parameters \eqn{a_1, \dots , d_1} and \eqn{a_2, \dots , d_2} to have a
pairwise equivalent normal distribution (in large sample sets).
}
\examples{
data(cancer)
data(krebs)

# investigate a single marker:
trinROC.test(dat = cancer[,c(1,3)])
trinROC.test(dat = krebs[,c(1,5)])

# result is equal to:
x1 <- with(cancer, cancer[trueClass=="healthy", 3])
y1 <- with(cancer, cancer[trueClass=="intermediate", 3])
z1 <- with(cancer, cancer[trueClass=="diseased", 3])
trinROC.test(x1, y1, z1)

# comparison of marker 2 and 6:
trinROC.test(dat = cancer[,c(1,3,5)], paired = TRUE)
trinROC.test(dat = cancer[,c(1,3,5)], paired = FALSE)

# result is equal to:
x2 <- with(cancer, cancer[trueClass=="healthy", 5])
y2 <- with(cancer, cancer[trueClass=="intermediate", 5])
z2 <- with(cancer, cancer[trueClass=="diseased", 5])
trinROC.test(x1, y1, z1, x2, y2, z2, paired = TRUE)
}
\references{
Noll, S., Furrer, R., Reiser, B. and Nakas, C. T. (2018).
  Inference in ROC surface analysis via a trinormal model-based testing approach.
  \emph{Submitted}.
}
\seealso{
\code{\link{trinVUS.test}}, \code{\link{boot.test}}.
}
