% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/efftox_params.R
\docType{class}
\name{efftox_params-class}
\alias{efftox_params-class}
\alias{efftox_params}
\title{Container class for parameters to fit the EffTox model in trialr.}
\usage{
efftox_params(
  real_doses,
  efficacy_hurdle,
  toxicity_hurdle,
  p_e,
  p_t,
  eff0,
  tox1,
  eff_star,
  tox_star,
  priors
)
}
\arguments{
\item{real_doses}{a vector of numbers.The doses under investigation.
They should be ordered from lowest to highest and be in consistent units.
E.g., to conduct a dose-finding trial of doses 10mg, 20mg and 50mg, use
c(10, 20, 50).}

\item{efficacy_hurdle}{Minimum acceptable efficacy probability.
A number between 0 and 1.}

\item{toxicity_hurdle}{Maximum acceptable toxicity probability.
A number between 0 and 1.}

\item{p_e}{Certainty required to infer a dose is acceptable with regards to
being probably efficacious; a number between 0 and 1.}

\item{p_t}{Certainty required to infer a dose is acceptable with regards to
being probably tolerable; a number between 0 and 1.}

\item{eff0}{Efficacy probability required when toxicity is impossible;
a number between 0 and 1 (see Details).}

\item{tox1}{Toxicity probability permitted when efficacy is guaranteed;
a number between 0 and 1 (see Details).}

\item{eff_star}{Efficacy probability of an equi-utility third point (see
Details).}

\item{tox_star}{Toxicity probability of an equi-utility third point (see
Details).}

\item{priors}{instance of class \code{\link{efftox_priors}}, the
hyperparameters for normal priors on the six model parameters.}
}
\description{
Container class for parameters to fit the EffTox model in trialr.
}
\seealso{
\code{\link{efftox_priors}}
\code{\link{get_efftox_priors}}
\code{\link{stan_efftox}}
\code{\link{stan_efftox_demo}}
}
