% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-methods.R
\name{getNdsAge}
\alias{getNdsAge}
\title{Get ages for multiple nodes}
\usage{
getNdsAge(tree, ids, ...)
}
\arguments{
\item{tree}{\code{TreeMan} object}

\item{ids}{vector of node ids}

\item{...}{\code{plyr} arguments}
}
\description{
Return the root to tip distances for \code{ids}.
}
\details{
Returns a vector, parallelizable.
}
\examples{
library(treeman)
tree <- randTree(10)
getNdsAge(tree, ids=tree['nds'])
}
\seealso{
\code{\link{getNdAge}}, 
\code{\link{getSpnAge}}, 
\code{\link{getSpnsAge}}, 
\url{https://github.com/DomBennett/treeman/wiki/get-methods}
}

