#' Correction Factors for Tree Plot Areas Intersected by Stand
#' Boundaries
#'
#' The German national forest inventory uses angle count sampling, a
#' sampling method first published by Bitterlich (1947) and extended by
#' Grosenbaugh (1952) as probability proportional to size sampling. When plots
#' are located near stand boundaries, their sizes and hence their
#' probabilities need to be corrected.
#'
#' You will find the details in\cr
#' \code{vignette("An_Introduction_to_treePlotArea", package =
#' "treePlotArea")}.
#'
#' @references
#' \cite{
#' Bitterlich, W. (1947): Die Winkelzählmessung.
#' Allgemeine Forst- und Holzwirtschaftliche Zeitung, 58.
#' }
#'
#' \cite{
#' Grosenbaugh, L. R. (1952): Plotless Timber Estimates -- New, Fast, Easy.
#' Journal of Forestry.
#' https://academic.oup.com/jof/article-abstract/50/1/32/4684174.
#' }
#' @name treePlotArea-package
#' @aliases treePlotArea-package
#' @docType package
#' @keywords package
NULL
