% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epts.R
\name{raw_epts}
\alias{raw_epts}
\title{Estimated Post-Transplant Survival Score (EPTS)}
\usage{
raw_epts(age, dm, prev_tx, dx)
}
\arguments{
\item{age}{numeric vector of patient age in years (with decimals)}

\item{dm}{numeric vector of whether patient diabetic (1 = yes, 0 = no)}

\item{prev_tx}{numeric vector of whether patient has a previous solid organ transplant}

\item{dx}{numeric vector of duration of dialysis in years (with decimals)}
}
\value{
numeric vector of raw EPTS scores
}
\description{
A vectorised function to calculate raw EPTS scores for norm-related prediction of
patient survival after adult renal transplants. This function generates the raw
EPTS scores which can be converted to percentiles using the lookup table on the OPTN
website at https://optn.transplant.hrsa.gov/media/2973/epts_mapping_table_2018.pdf
}
\details{
References: https://optn.transplant.hrsa.gov/resources/allocation-calculators/epts-calculator/ and
https://optn.transplant.hrsa.gov/media/1511/guide_to_calculating_interpreting_epts.pdf
}
\examples{
raw_epts(age = 23.5838467, dm = 0, prev_tx = 1, dx = 5.0814511) # 0.9666517
raw_epts(age = 52.8788501, dm = 0, prev_tx = 0, dx = 0) # 1.440306
raw_epts(age = 22.5242984, dm = 1, prev_tx = 1, dx = 6.8747433) # 1.868751
}
