% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pancreas.R
\name{pdri}
\alias{pdri}
\title{Pancreas donor risk index}
\usage{
pdri(age, sex, creat, eth, bmi, height, cva, cit, dcd, intent = c("SPK",
  "PAK", "Other"), units = "SI")
}
\arguments{
\item{age}{numeric vector of ages in years}

\item{sex}{character vector of patient sex ("F" for female, "M" for male)}

\item{creat}{numeric vector of serum creatinine (µmol/l by default)}

\item{eth}{character vector of ethnicity, one of "asian", "black" or "other" in each case}

\item{bmi}{numeric vector of body mass index (BMI)}

\item{height}{numeric vector of heights in centimetres}

\item{cva}{numeric vector of whether CVA is cause of death (1 = yes, 0 = no)}

\item{cit}{numeric vector of cold ischaemic times in hours}

\item{dcd}{numeric vector of whether donor after circulatory death (1 = DCD, 0 = DBD)}

\item{intent}{character vector of implant intent, "PAK" for pancreas after kidney or "other"}

\item{units}{single character string for creatinine units: one of "SI" (for µmol/l) or "US" (for mg/dl)}
}
\value{
numeric vector of pancreas donor risk index values
}
\description{
A vectorised function to calculate the Pancreas Donor Risk Index as published by Axelrod et al.
By default, the serum creatinine is used in mcmmol/l but this can be changed to mg/dl by setting
the optional units parameter to "US"
}
\details{
Reference: Axelrod DA, Sung RS, Meyer KH, et al. Systematic evaluation of pancreas allograft
quality, outcomes and geographic variation in utilization. Am J Transplant 2010; 10(4):837-45.
}
\examples{
pdri(age = 28, sex = "M", creat = 1.0, eth = "other", bmi = 24,
height = 173, cva = 0, cit = 12, dcd = 0, units = "US") # 1.00

pdri(age = 45, sex = "M", creat = 88.4, eth = "other", bmi = 24,
height = 173, cva = 0, cit = 12, dcd = 0, units = "SI") # 1.56
}
