% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lagtime.R
\name{lagtime}
\alias{lagtime}
\alias{lagtime.default}
\alias{lagtime.units}
\alias{lagtime.stars}
\alias{lagtime.transfR}
\title{Lag time estimation}
\usage{
lagtime(hl, ...)

\method{lagtime}{default}(hl, uc, ...)

\method{lagtime}{units}(hl, uc, method = 1, ...)

\method{lagtime}{stars}(hl, ...)

\method{lagtime}{transfR}(hl, verbose = TRUE, ...)
}
\arguments{
\item{hl}{hydraulic length of class \code{transfR} or \code{stars} or \code{matrix} or \code{vector}.
If no unit is provided, \code{hl} is assumed to be in [m].}

\item{...}{further arguments passed to or from other methods}

\item{uc}{streamflow velocity. If no unit is provided, \code{uc} is assumed to be in [m/s].}

\item{method}{integer describing the method to use for lag time estimation. Possible values: 1 (see details).}

\item{verbose}{boolean indicating if information messages should be written to the console.}
}
\value{
A numeric value of class units, or if \code{hl} is a transfR object,
the same transfR object incremented by the "lagtime" attribute.
}
\description{
Estimate the lag time of the catchment.
}
\details{
The function estimates the lag time of the catchment. It can be used to estimate one of the
inputs of the function \link{rapriori}. If \code{method} is 1, the lag time is estimated
from the ratio of the mean hydraulic length (\code{hl}) and the average streamflow velocity (\code{uc}).
}
\examples{
data(Oudon)
icatch <- 1
lagtime(Oudon$hl[[icatch]],uc=units::set_units(0.5,"m/s"))
}
