% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gendata.R
\name{gendata}
\alias{gendata}
\title{Generate data trajectories for MSM}
\usage{
gendata(
  n,
  include_censor = FALSE,
  format = c("long", "wide"),
  start_year = 2011,
  total_followup,
  timedep_outcome = FALSE,
  seed
)
}
\arguments{
\item{n}{Number of observations to generate.}

\item{include_censor}{Logical, if TRUE, includes censoring.}

\item{format}{Character, either "long" or "wide" for the format of the output data frame.}

\item{start_year}{Baseline year.}

\item{total_followup}{Number of measuring times.}

\item{timedep_outcome}{Logical, if TRUE, includes a time-dependent outcome.}

\item{seed, }{Use a specific seed value to ensure the simulated data is replicable.}
}
\value{
A data frame with generated data trajectories.
}
\description{
Provides datasets for running examples for LCGA-MSM and LCGA-HRMSM.
}
\examples{
gendata(n = 100, include_censor = FALSE, format = "wide",total_followup = 3, seed = 945)
}
