% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Reciprocal.R
\name{reciprocal}
\alias{reciprocal}
\title{Reciprocal transformation for linear models}
\usage{
reciprocal(object)
}
\arguments{
\item{object}{an object of type lm.}
}
\value{
An object of class \code{trafo}. Methods such as 
\code{\link{as.data.frame.trafo}} and \code{\link{print.trafo}} can 
be used for this class.
}
\description{
The function transforms the dependent variable of a linear model using the 
Reciprocal transformation.
}
\examples{
# Load data
data("cars", package = "datasets")

# Fit linear model
lm_cars <- lm(dist ~ speed, data = cars)

# Transform dependent variable 
reciprocal(object = lm_cars)
}
