% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oneparam.lm.R
\name{oneparam.lm}
\alias{oneparam.lm}
\title{One parameter transformations for linear models}
\usage{
\method{oneparam}{lm}(object, trafo, lambda = "estim", method = "ml",
  lambdarange, plotit = TRUE, custom_trafo = NULL, ...)
}
\arguments{
\item{object}{an object of type lm.}

\item{trafo}{character that determines the selected transformation.}

\item{lambda}{either a character named "estim" if the optimal transformation
parameter should be estimated or a numeric value determining a given 
transformation parameter. Defaults to "estim".}

\item{method}{a character string. Different estimation methods can be used 
for the estimation of the optimal transformation parameter: 
(i) Maximum likelihood approach ("ml"), (ii) Skewness minimization ("skew"),
(iii) Kurtosis optimization ("kurt"), (iv) Divergence minimization by 
Kolmogorov-Smirnov ("div.ks"), by Cramer-von-Mises ("div.cvm") or by 
Kullback-Leibler ("div.kl"). Defaults to "ml".}

\item{lambdarange}{a numeric vector with two elements defining an interval 
that is used for the estimation of the optimal transformation parameter. 
Defaults to \code{c(-2, 2)}.}

\item{plotit}{logical. If \code{TRUE}, a plot that illustrates the optimal 
transformation parameter or the given transformation parameter is returned.}

\item{custom_trafo}{a list that determines a one parameter transformation and
the standardized one parameter transformation.}

\item{...}{other parameters that can be passed to the function.}
}
\value{
an object of class \code{trafo}.
}
\description{
The function transforms the dependent variable of a linear model using the 
one parameter transformations. The transformation parameter can either be 
estimated using different estimation methods or given.
}
\keyword{internal}
