% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estim.R
\name{estim_lm}
\alias{estim_lm}
\title{Wrapper function for estimation methods - linear models}
\usage{
estim_lm(lambda, y, x, method, trafo, custom_func, custom_func_std)
}
\arguments{
\item{lambda}{transformation parameter}

\item{y}{vector of response variables}

\item{x}{matrix of regressors}

\item{method}{a character string. Different estimation methods can be used 
for the estimation of the optimal transformation parameter: 
(i) Maximum likelihood approach ("ml"), (ii) Skewness minimization ("skew"),
(iii) Kurtosis optimization ("kurt"), (iv) Divergence minimization by 
Kolmogorov-Smirnov ("div.ks"), by Cramer-von-Mises ("div.cvm") or by 
Kullback-Leibler ("div.kl"). Defaults to "ml". In case of no and
log transformation "NA" can be selected since no optimization is necessary
for these two transformation types.}

\item{trafo}{a character string that selects the transformation.}

\item{custom_func}{a function that determines a customized transformation.}

\item{custom_func_std}{a function that determines a customized standard
transformation.}
}
\value{
Depending on the selected \code{method} the return is a log
likelihood, a skewness, a pooled skewness or a Kolmogorov-Smirnov, Cramer
von Mises or Kullback Leibler divergence.
}
\description{
Wrapper function for estimation methods - linear models
}
\keyword{internal}
