% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/errors.R
\name{inconsistent_xy}
\alias{inconsistent_xy}
\title{Find Inconsistent Locations in a Track Table}
\usage{
inconsistent_xy(x, s = 5)
}
\arguments{
\item{x}{\code{\link{track}} table as produced by the \code{\link{track}}
function.}

\item{s}{The discrimination threshold of the outlier detection algorithm.
Higher values correspond to less outliers.}
}
\value{
A data frame/table/tibble with the timestamps and coordinates of the
 the inconsistent data for each individual track in \code{x}. If no
 inconsistencies are detected, the function returns \code{NULL}.
}
\description{
This function attempts to automatically detect inconsistent
 locations (for instance due to a writing error or GPS innacuracies) in
 \code{\link{track}} tables.
}
\examples{
# Create data set with inconsistent data
data(tracks)
t_df <- track(x = tracks$x, y = tracks$y, t = tracks$t,
              id = tracks$id, proj = "+proj=longlat",
              tz = "Africa/Windhoek", table = "df")
t_df$x[1000] <- t_df$x[1000] * 1.0001
t_df$y[4000] <- t_df$y[4000] * 1.00001

# Find inconsistent data
inconsitent <- inconsistent_xy(t_df)

}
\seealso{
\code{\link{track}}
}
\author{
Simon Garnier, \email{garnier@njit.edu}
}
