% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topicsInText.R
\name{topicsInText}
\alias{topicsInText}
\title{Coloring the words of a text corresponding to topic allocation}
\usage{
topicsInText(
  text,
  ldaID,
  id,
  ldaresult,
  label = NULL,
  vocab,
  wordOrder = c("both", "alphabetical", "topics", ""),
  colors = NULL,
  fixColors = FALSE,
  meta = NULL,
  originaltext = NULL,
  unclearTopicAssignment = TRUE,
  htmlreturn = FALSE
)
}
\arguments{
\item{text}{The result of \code{\link{LDAprep}}}

\item{ldaID}{List of IDs for \code{text}}

\item{id}{ID of the article of interest}

\item{ldaresult}{A result object from the \code{standardLDA}}

\item{label}{Optional label for each topic}

\item{vocab}{Character: Vector of \code{vocab} corresponding to the \code{text} object}

\item{wordOrder}{Type of output: \code{"alphabetical"} prints the words of the article in alphabetical order, \code{"topics"} sorts by topic (biggest topic first) and \code{"both"} prints both versions. All other inputs will result to no output (this makes only sense in combination with \code{originaltext}.}

\item{colors}{Character vector of colors. If the vector is shorter than the number of topics it will be completed by "black" entrys.}

\item{fixColors}{Logical: If \code{FALSE} the first color will be used for the biggest topic and so on. If \code{fixColors=TRUE} the the color-entry corresponding to the position of the topic is choosen.}

\item{meta}{Optional input for meta data. It will be printed in the header of the output.}

\item{originaltext}{Optional a list of texts (the \code{text} list of the \code{textmeta} object) including the desired text. Listnames must be IDs. Necessary for output in original text}

\item{unclearTopicAssignment}{Logical: If TRUE all words which are assigned to more than one topic will not be colored. Otherwise the words will be colored in order of topic apperance in the \code{ldaresult}.}

\item{htmlreturn}{Logical: HTML output for tests}
}
\value{
A HTML document
}
\description{
The function creates a HTML document with the words of texts colored depending on the topic allocation of each word.
}
\examples{
\dontrun{
data(politics)
poliClean <- cleanTexts(politics)
words10 <- makeWordlist(text=poliClean$text)
words10 <- words10$words[words10$wordtable > 10]
poliLDA <- LDAprep(text=poliClean$text, vocab=words10)
LDAresult <- LDAgen(documents=poliLDA, K=10, vocab=words10)
topicsInText(text=politics$text, ldaID=names(poliLDA), id="ID2756",
             ldaresult=LDAresult, vocab=words10)}
}
