% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readTextmeta.R
\name{readTextmeta}
\alias{readTextmeta}
\alias{readTextmeta.df}
\title{Read Corpora as CSV}
\usage{
readTextmeta(
  path,
  file,
  cols,
  dateFormat = "\%Y-\%m-\%d",
  idCol = "id",
  dateCol = "date",
  titleCol = "title",
  textCol = "text",
  encoding = "UTF-8",
  xmlAction = TRUE,
  duplicateAction = TRUE
)

readTextmeta.df(
  df,
  cols = colnames(df),
  dateFormat = "\%Y-\%m-\%d",
  idCol = "id",
  dateCol = "date",
  titleCol = "title",
  textCol = "text",
  xmlAction = TRUE,
  duplicateAction = TRUE
)
}
\arguments{
\item{path}{\code{character/data.frame} string with path where the data files
are OR parameter \code{df} for \code{readTextmeta.df}}

\item{file}{\code{character} string with names of the CSV files}

\item{cols}{\code{character} vector with columns which should be kept}

\item{dateFormat}{\code{character} string with the date format in the files
for \code{\link{as.Date}}}

\item{idCol}{\code{character} string with column name of the IDs}

\item{dateCol}{\code{character} string with column name of the Dates}

\item{titleCol}{\code{character} string with column name of the Titles}

\item{textCol}{\code{character} string with column name of the Texts}

\item{encoding}{character string with encoding specification of the files}

\item{xmlAction}{\code{logical} whether all columns of the CSV should be
handled with \code{\link{removeXML}}}

\item{duplicateAction}{\code{logical}
whether \code{\link{deleteAndRenameDuplicates}} should be applied to the
created \code{\link{textmeta}} object}

\item{df}{\code{data.frame} table which should be transformed to a textmeta object}
}
\value{
\code{\link{textmeta}} object
}
\description{
Reads CSV-files and seperates the text and meta data. The result is a
\code{\link{textmeta}} object.
}
\keyword{manip}
