% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transforms.R
\name{transform_time_stretch}
\alias{transform_time_stretch}
\title{Time Stretch}
\usage{
transform_time_stretch(hop_length = NULL, n_freq = 201, fixed_rate = NULL)
}
\arguments{
\item{hop_length}{(int or NULL, optional): Length of hop between STFT windows. (Default: \verb{win_length // 2})}

\item{n_freq}{(int, optional): number of filter banks from stft. (Default: \code{201})}

\item{fixed_rate}{(float or NULL, optional): rate to speed up or slow down by.
If NULL is provided, rate must be passed to the forward method.  (Default: \code{NULL})}
}
\value{
Tensor: Stretched complex spectrogram of dimension (..., freq, ceil(time/rate), complex=2).
}
\description{
Stretch stft in time without modifying pitch for a given rate.
}
\details{
forward param:
complex_specgrams  (Tensor): complex spectrogram (..., freq, time, complex=2).

overriding_rate  (float or NULL, optional): speed up to apply to this batch.
If no rate is passed, use \code{self$fixed_rate}.  (Default: \code{NULL})
}
