% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/gen-namespace.R
\name{torch_logcumsumexp}
\alias{torch_logcumsumexp}
\title{Logcumsumexp}
\usage{
torch_logcumsumexp(self, dim)
}
\arguments{
\item{self}{(Tensor) the input tensor.}

\item{dim}{(int) the dimension to do the operation over}
}
\description{
Logcumsumexp
}
\section{logcumsumexp(input, dim, *, out=None) -> Tensor }{


Returns the logarithm of the cumulative summation of the exponentiation of
elements of \code{input} in the dimension \code{dim}.

For summation index \eqn{j} given by \code{dim} and other indices \eqn{i}, the result is

\deqn{
        \mbox{logcumsumexp}(x)_{ij} = \log \sum\limits_{j=0}^{i} \exp(x_{ij})
}
}

\examples{
if (torch_is_installed()) {

a <- torch_randn(c(10))
torch_logcumsumexp(a, dim=1)
}
}
