% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn-loss.R
\name{nn_multi_margin_loss}
\alias{nn_multi_margin_loss}
\title{Multi margin loss}
\usage{
nn_multi_margin_loss(p = 1, margin = 1, weight = NULL, reduction = "mean")
}
\arguments{
\item{p}{(int, optional): Has a default value of \eqn{1}. \eqn{1} and \eqn{2}
are the only supported values.}

\item{margin}{(float, optional): Has a default value of \eqn{1}.}

\item{weight}{(Tensor, optional): a manual rescaling weight given to each
class. If given, it has to be a Tensor of size \code{C}. Otherwise, it is
treated as if having all ones.}

\item{reduction}{(string, optional): Specifies the reduction to apply to the output:
\code{'none'} | \code{'mean'} | \code{'sum'}. \code{'none'}: no reduction will be applied,
\code{'mean'}: the sum of the output will be divided by the number of
elements in the output, \code{'sum'}: the output will be summed. Note: \code{size_average}
and \code{reduce} are in the process of being deprecated, and in the meantime,
specifying either of those two args will override \code{reduction}. Default: \code{'mean'}}
}
\description{
Creates a criterion that optimizes a multi-class classification hinge
loss (margin-based loss) between input \eqn{x} (a 2D mini-batch \code{Tensor}) and
output \eqn{y} (which is a 1D tensor of target class indices,
\eqn{0 \leq y \leq \mbox{x.size}(1)-1}):
}
\details{
For each mini-batch sample, the loss in terms of the 1D input \eqn{x} and scalar
output \eqn{y} is:
\deqn{
  \mbox{loss}(x, y) = \frac{\sum_i \max(0, \mbox{margin} - x[y] + x[i]))^p}{\mbox{x.size}(0)}
}

where \eqn{x \in \left\{0, \; \cdots , \; \mbox{x.size}(0) - 1\right\}}
and \eqn{i \neq y}.

Optionally, you can give non-equal weighting on the classes by passing
a 1D \code{weight} tensor into the constructor.
The loss function then becomes:

\deqn{
  \mbox{loss}(x, y) = \frac{\sum_i \max(0, w[y] * (\mbox{margin} - x[y] + x[i]))^p)}{\mbox{x.size}(0)}
}
}
