% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/gen-namespace.R
\name{torch_logaddexp}
\alias{torch_logaddexp}
\title{Logaddexp}
\usage{
torch_logaddexp(self, other)
}
\arguments{
\item{self}{(Tensor) the input tensor.}

\item{other}{(Tensor) the second input tensor}
}
\description{
Logaddexp
}
\section{logaddexp(input, other, *, out=None) -> Tensor }{


Logarithm of the sum of exponentiations of the inputs.

Calculates pointwise \eqn{\log\left(e^x + e^y\right)}. This function is useful
in statistics where the calculated probabilities of events may be so small as to
exceed the range of normal floating point numbers. In such cases the logarithm
of the calculated probability is stored. This function allows adding
probabilities stored in such a fashion.

This op should be disambiguated with \code{\link[=torch_logsumexp]{torch_logsumexp()}} which performs a
reduction on a single tensor.
}

\examples{
if (torch_is_installed()) {

torch_logaddexp(torch_tensor(c(-1.0)), torch_tensor(c(-1.0, -2, -3)))
torch_logaddexp(torch_tensor(c(-100.0, -200, -300)), torch_tensor(c(-1.0, -2, -3)))
torch_logaddexp(torch_tensor(c(1.0, 2000, 30000)), torch_tensor(c(-1.0, -2, -3)))
}
}
