% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nnf-conv.R
\name{nnf_conv_transpose3d}
\alias{nnf_conv_transpose3d}
\title{Conv_transpose3d}
\usage{
nnf_conv_transpose3d(
  input,
  weight,
  bias = NULL,
  stride = 1,
  padding = 0,
  output_padding = 0,
  groups = 1,
  dilation = 1
)
}
\arguments{
\item{input}{input tensor of shape (minibatch, in_channels , iT , iH , iW)}

\item{weight}{filters of shape (out_channels , in_channels/groups, kT , kH , kW)}

\item{bias}{optional bias tensor of shape (out_channels). Default: \code{NULL}}

\item{stride}{the stride of the convolving kernel. Can be a single number or a
tuple \verb{(sT, sH, sW)}. Default: 1}

\item{padding}{implicit paddings on both sides of the input. Can be a
single number or a tuple \verb{(padT, padH, padW)}. Default: 0}

\item{output_padding}{padding applied to the output}

\item{groups}{split input into groups, \code{in_channels} should be divisible by
the number of groups. Default: 1}

\item{dilation}{the spacing between kernel elements. Can be a single number or
a tuple \verb{(dT, dH, dW)}. Default: 1}
}
\description{
Applies a 3D transposed convolution operator over an input image
composed of several input planes, sometimes also called "deconvolution"
}
