% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn-activation.R
\name{nn_hardshrink}
\alias{nn_hardshrink}
\title{Hardshwink module}
\usage{
nn_hardshrink(lambd = 0.5)
}
\arguments{
\item{lambd}{the \eqn{\lambda} value for the Hardshrink formulation. Default: 0.5}
}
\description{
Applies the hard shrinkage function element-wise:
}
\details{
\deqn{
  \mbox{HardShrink}(x) =
  \left\{ \begin{array}{ll}
x, & \mbox{ if } x > \lambda \\
x, & \mbox{ if } x < -\lambda \\
0, & \mbox{ otherwise }
\end{array}
\right.
}
}
\section{Shape}{

\itemize{
\item Input: \eqn{(N, *)} where \code{*} means, any number of additional
dimensions
\item Output: \eqn{(N, *)}, same shape as the input
}
}

\examples{
if (torch_is_installed()) {
m <- nn_hardshrink()
input <- torch_randn(2)
output <- m(input)
}
}
