% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn-pooling.R
\name{nn_max_unpool2d}
\alias{nn_max_unpool2d}
\title{Computes a partial inverse of \code{MaxPool2d}.}
\usage{
nn_max_unpool2d(kernel_size, stride = NULL, padding = 0)
}
\arguments{
\item{kernel_size}{(int or tuple): Size of the max pooling window.}

\item{stride}{(int or tuple): Stride of the max pooling window.
It is set to \code{kernel_size} by default.}

\item{padding}{(int or tuple): Padding that was added to the input}
}
\description{
\code{MaxPool2d} is not fully invertible, since the non-maximal values are lost.
\code{MaxUnpool2d} takes in as input the output of \code{MaxPool2d}
including the indices of the maximal values and computes a partial inverse
in which all non-maximal values are set to zero.
}
\note{
\code{MaxPool2d} can map several input sizes to the same output
sizes. Hence, the inversion process can get ambiguous.
To accommodate this, you can provide the needed output size
as an additional argument \code{output_size} in the forward call.
See the Inputs and Example below.
}
\section{Inputs}{

\itemize{
\item \code{input}: the input Tensor to invert
\item \code{indices}: the indices given out by \code{\link[=nn_max_pool2d]{nn_max_pool2d()}}
\item \code{output_size} (optional): the targeted output size
}
}

\section{Shape}{

\itemize{
\item Input: \eqn{(N, C, H_{in}, W_{in})}
\item Output: \eqn{(N, C, H_{out}, W_{out})}, where
\deqn{
  H_{out} = (H_{in} - 1) \times \mbox{stride[0]} - 2 \times \mbox{padding[0]} + \mbox{kernel\_size[0]}
}
\deqn{
  W_{out} = (W_{in} - 1) \times \mbox{stride[1]} - 2 \times \mbox{padding[1]} + \mbox{kernel\_size[1]}
}
or as given by \code{output_size} in the call operator
}
}

\examples{
if (torch_is_installed()) {

pool <- nn_max_pool2d(2, stride=2, return_indices=TRUE)
unpool <- nn_max_unpool2d(2, stride=2)
input <- torch_randn(1,1,4,4)
out <- pool(input)
unpool(out[[1]], out[[2]])

# specify a different output size than input size
unpool(out[[1]], out[[2]], output_size=c(1, 1, 5, 5))

}
}
