% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn-activation.R
\name{nn_hardsigmoid}
\alias{nn_hardsigmoid}
\title{Hardsigmoid module}
\usage{
nn_hardsigmoid()
}
\description{
Applies the element-wise function:
}
\details{
\deqn{
\mbox{Hardsigmoid}(x) = \left\{ \begin{array}{ll}
  0 & \mbox{if~} x \le -3, \\
  1 & \mbox{if~} x \ge +3, \\
  x / 6 + 1 / 2 & \mbox{otherwise}
\end{array}
\right.
}
}
\section{Shape}{

\itemize{
\item Input: \eqn{(N, *)} where \code{*} means, any number of additional
dimensions
\item Output: \eqn{(N, *)}, same shape as the input
}
}

\examples{
if (torch_is_installed()) {
m <- nn_hardsigmoid()
input <- torch_randn(2)
output <- m(input)

}
}
