% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/gen-namespace.R
\name{torch_ifft}
\alias{torch_ifft}
\title{Ifft}
\usage{
torch_ifft(self, signal_ndim, normalized = FALSE)
}
\arguments{
\item{self}{(Tensor) the input tensor of at least \code{signal_ndim} \code{+ 1}        dimensions}

\item{signal_ndim}{(int) the number of dimensions in each signal.        \code{signal_ndim} can only be 1, 2 or 3}

\item{normalized}{(bool, optional) controls whether to return normalized results.        Default: \code{FALSE}}
}
\description{
Ifft
}
\note{
\preformatted{For CUDA tensors, an LRU cache is used for cuFFT plans to speed up
repeatedly running FFT methods on tensors of same geometry with same
configuration. See cufft-plan-cache for more details on how to
monitor and control the cache.
}
}
\section{ifft(input, signal_ndim, normalized=False) -> Tensor }{


Complex-to-complex Inverse Discrete Fourier Transform

This method computes the complex-to-complex inverse discrete Fourier
transform. Ignoring the batch dimensions, it computes the following
expression:

\deqn{
    X[\omega_1, \dots, \omega_d] =
        \frac{1}{\prod_{i=1}^d N_i} \sum_{n_1=0}^{N_1-1} \dots \sum_{n_d=0}^{N_d-1} x[n_1, \dots, n_d]
         e^{\ j\ 2 \pi \sum_{i=0}^d \frac{\omega_i n_i}{N_i}},
}
where \eqn{d} = \code{signal_ndim} is number of dimensions for the
signal, and \eqn{N_i} is the size of signal dimension \eqn{i}.

The argument specifications are almost identical with \code{\link{torch_fft}}.
However, if \code{normalized} is set to \code{TRUE}, this instead returns the
results multiplied by \eqn{\sqrt{\prod_{i=1}^d N_i}}, to become a unitary
operator. Therefore, to invert a \code{\link{torch_fft}}, the \code{normalized}
argument should be set identically for \code{\link{torch_fft}}.

Returns the real and the imaginary parts together as one tensor of the same
shape of \code{input}.

The inverse of this function is \code{\link{torch_fft}}.
}

\section{Warning}{

For CPU tensors, this method is currently only available with MKL. Use
\code{torch_backends.mkl.is_available} to check if MKL is installed.
}

\examples{
if (torch_is_installed()) {

x = torch_randn(c(3, 3, 2))
x
y = torch_fft(x, 2)
torch_ifft(y, 2)  # recover x
}
}
