% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nnf-activation.R
\name{nnf_elu}
\alias{nnf_elu}
\alias{nnf_elu_}
\title{Elu}
\usage{
nnf_elu(input, alpha = 1, inplace = FALSE)

nnf_elu_(input, alpha = 1)
}
\arguments{
\item{input}{(N,*) tensor, where * means, any number of additional
dimensions}

\item{alpha}{the alpha value for the ELU formulation. Default: 1.0}

\item{inplace}{can optionally do the operation in-place. Default: FALSE}
}
\description{
Applies element-wise,
\deqn{ELU(x) = max(0,x) + min(0, \alpha * (exp(x) - 1))}.
}
\examples{
if (torch_is_installed()) {
x <- torch_randn(2, 2)
y <- nnf_elu(x, alpha = 1)
nnf_elu_(x, alpha = 1)
torch_equal(x, y)

}
}
