% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn-dropout.R
\name{nn_dropout}
\alias{nn_dropout}
\title{Dropout module}
\usage{
nn_dropout(p = 0.5, inplace = FALSE)
}
\arguments{
\item{p}{probability of an element to be zeroed. Default: 0.5}

\item{inplace}{If set to \code{TRUE}, will do this operation in-place. Default: \code{FALSE}.}
}
\description{
During training, randomly zeroes some of the elements of the input
tensor with probability \code{p} using samples from a Bernoulli
distribution. Each channel will be zeroed out independently on every forward
call.
}
\details{
This has proven to be an effective technique for regularization and
preventing the co-adaptation of neurons as described in the paper
\href{https://arxiv.org/abs/1207.0580}{Improving neural networks by preventing co-adaptation of feature detectors}.

Furthermore, the outputs are scaled by a factor of :math:\verb{\\frac\{1\}\{1-p\}} during
training. This means that during evaluation the module simply computes an
identity function.
}
\section{Shape}{

\itemize{
\item Input: \eqn{(*)}. Input can be of any shape
\item Output: \eqn{(*)}. Output is of the same shape as input
}
}

\examples{
if (torch_is_installed()) {
m <- nn_dropout(p = 0.2)
input <- torch_randn(20, 16)
output <- m(input)

}
}
