% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-data.R
\name{dataset}
\alias{dataset}
\title{An abstract class representing a \code{Dataset}.}
\usage{
dataset(name = NULL, inherit = Dataset, ..., parent_env = parent.frame())
}
\arguments{
\item{name}{a name for the dataset. It it's also used as the class
for it.}

\item{inherit}{you can optionally inherit from a dataset when creating a
new dataset.}

\item{...}{public methods for the dataset class}

\item{parent_env}{An environment to use as the parent of newly-created
objects.}
}
\description{
All datasets that represent a map from keys to data samples should subclass
it. All subclasses should overwrite \code{get_item}, supporting fetching a
data sample for a given key. Subclasses could also optionally overwrite
\code{lenght}, which is expected to return the size of the dataset by many
\code{~torch.utils.data.Sampler} implementations and the default options
of \code{~torch.utils.data.DataLoader}.
}
\note{
\code{~torch.utils.data.DataLoader} by default constructs a index
sampler that yields integral indices.  To make it work with a map-style
dataset with non-integral indices/keys, a custom sampler must be provided.
}
