% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R
\name{torch_mean}
\alias{torch_mean}
\title{Mean}
\arguments{
\item{input}{(Tensor) the input tensor.}

\item{dim}{(int or tuple of ints) the dimension or dimensions to reduce.}

\item{keepdim}{(bool) whether the output tensor has \code{dim} retained or not.}

\item{out}{(Tensor, optional) the output tensor.}
}
\description{
Mean
}
\section{mean(input) -> Tensor }{


Returns the mean value of all elements in the \code{input} tensor.
}

\section{mean(input, dim, keepdim=False, out=None) -> Tensor }{


Returns the mean value of each row of the \code{input} tensor in the given
dimension \code{dim}. If \code{dim} is a list of dimensions,
reduce over all of them.

If \code{keepdim} is \code{True}, the output tensor is of the same size
as \code{input} except in the dimension(s) \code{dim} where it is of size 1.
Otherwise, \code{dim} is squeezed (see \code{\link{torch_squeeze}}), resulting in the
output tensor having 1 (or \code{len(dim)}) fewer dimension(s).
}

\examples{
if (torch_is_installed()) {

a = torch_randn(c(1, 3))
a
torch_mean(a)


a = torch_randn(c(4, 4))
a
torch_mean(a, 1)
torch_mean(a, 1, TRUE)
}
}
