% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nnf-upsampling.R
\name{nnf_interpolate}
\alias{nnf_interpolate}
\title{Interpolate}
\usage{
nnf_interpolate(
  input,
  size = NULL,
  scale_factor = NULL,
  mode = "nearest",
  align_corners = FALSE,
  recompute_scale_factor = NULL
)
}
\arguments{
\item{input}{(Tensor) the input tensor}

\item{size}{(int or \code{Tuple[int]} or \code{Tuple[int, int]} or \code{Tuple[int, int, int]})
output spatial size.}

\item{scale_factor}{(float or \code{Tuple[float]}) multiplier for spatial size.
Has to match input size if it is a tuple.}

\item{mode}{(str) algorithm used for upsampling: 'nearest' | 'linear' | 'bilinear'
| 'bicubic' | 'trilinear' | 'area' Default: 'nearest'}

\item{align_corners}{(bool, optional) Geometrically, we consider the pixels
of the input and output as squares rather than points. If set to TRUE,
the input and output tensors are aligned by the center points of their corner
pixels, preserving the values at the corner pixels. If set to False, the
input and output tensors are aligned by the corner points of their corner pixels,
and the interpolation uses edge value padding for out-of-boundary values,
making this operation \emph{independent} of input size when \code{scale_factor} is kept
the same. This only has an effect when \code{mode}  is \code{'linear'}, \code{'bilinear'},
\code{'bicubic'} or \code{'trilinear'}.  Default: \code{False}}

\item{recompute_scale_factor}{(bool, optional) recompute the scale_factor
for use in the interpolation calculation.  When \code{scale_factor} is passed
as a parameter, it is used to compute the \code{output_size}.  If \code{recompute_scale_factor}
is ```True`` or not specified, a new \code{scale_factor} will be computed based on
the output and input sizes for use in the interpolation computation (i.e. the
computation will be identical to if the computed `output_size` were passed-in
explicitly).  Otherwise, the passed-in `scale_factor` will be used in the
interpolation computation.  Note that when `scale_factor` is floating-point,
the recomputed scale_factor may differ from the one passed in due to rounding
and precision issues.}
}
\description{
Down/up samples the input to either the given \code{size} or the given
\code{scale_factor}
}
\details{
The algorithm used for interpolation is determined by \code{mode}.

Currently temporal, spatial and volumetric sampling are supported, i.e.
expected inputs are 3-D, 4-D or 5-D in shape.

The input dimensions are interpreted in the form:
\verb{mini-batch x channels x [optional depth] x [optional height] x width}.

The modes available for resizing are: \code{nearest}, \code{linear} (3D-only),
\code{bilinear}, \code{bicubic} (4D-only), \code{trilinear} (5D-only), \code{area}
}
