% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topoPaths.R
\name{topoPaths}
\alias{topoPaths}
\title{Identify shortest topographic paths}
\usage{
topoPaths(t.dist, pts)
}
\arguments{
\item{t.dist}{A TransitionLayer object.}

\item{pts}{A SpatialPoints object for the geographic points from which to calculate pairwise distances and paths.}
}
\value{
An object of class SpatialLines
}
\description{
Identify shortest topographic paths
}
\details{
This function identifies shortest topographic paths from a topographic TransitionLayer.  It does not need to be called separately from the topoDist and topoLCP functions.
}
\examples{
xy <- matrix(ncol = 2, byrow = TRUE,
   c(-119.5566, 37.72474,
   -119.4718, 37.76078))
xy <- sp::SpatialPoints(xy)
topoTL <- topoSurface(Yosemite$DEM)
topoPaths(topoTL, xy)
}
