% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tokenvis.r
\name{categorical_browser}
\alias{categorical_browser}
\title{Convert tokens into full texts in an HTML file with category highlighting}
\usage{
categorical_browser(
  tokens,
  category,
  alpha = 0.3,
  labels = NULL,
  meta = NULL,
  colors = NULL,
  doc_col = "doc_id",
  token_col = "token",
  filename = NULL,
  span_adjacent = T,
  ...
)
}
\arguments{
\item{tokens}{A data.frame with a column for document ids (doc_col)
and a column for tokens (token_col)}

\item{category}{Either a numeric vector with values representing categories, or a factor vector, in which case
the values are used as labels. If a numeric vector is used, the labels can also be specified in the labels argument}

\item{alpha}{Optionally, the alpha (transparency) can be specified, with 0 being fully
transparent and 1 being fully colored. This can be a vector to specify a
different alpha for each value.}

\item{labels}{A character vector giving names to the unique category values. If category is a factor vector, the factor levels are
used.}

\item{meta}{A data.frame with a column for document_ids (doc_col). All other columns are added
to the browser as document meta.}

\item{colors}{A character vector with color names for unique values of the category argument. Has to be the same length
as unique(na.omit(category))}

\item{doc_col}{The name of the document id column}

\item{token_col}{The name of the token column}

\item{filename}{Name of the output file. Default is temp file}

\item{span_adjacent}{If TRUE, include adjacent tokens with identical attributes within the same tag}

\item{...}{Additional formatting arguments passed to create_browser()}
}
\value{
The name of the file where the browser is saved. Can be opened conveniently from within R using browseUrl()
}
\description{
Convert tokens into full texts in an HTML file with category highlighting
}
\examples{
## as an example, use simple grep to code tokens
code = rep(NA, nrow(sotu_data$tokens))
code[grep('war', sotu_data$tokens$token)] = 'War'
code[grep('mother|father|child', sotu_data$tokens$token)] = 'Family'
code = as.factor(code)
url = categorical_browser(sotu_data$tokens, category=code, meta=sotu_data$meta)

\donttest{
view_browser(url)   ## view browser in the Viewer
browseURL(url)     ## view browser in default webbrowser
}
}
