% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tmt_msttemplate.R
\name{tmt_msttemplate}
\alias{tmt_msttemplate}
\title{Function to create a template for the multistage design used in tmt}
\usage{
tmt_msttemplate(formula = NULL, full = TRUE, eval = TRUE)
}
\arguments{
\item{formula}{formula for the desired template of a multistage design. If formula is leaved empty, a matrix as MST design template is generated.}

\item{full}{logical if the modules and rules sections should also be created}

\item{eval}{logical should the text input be evaluated (e.g. 3:6 = c(3, 4, 5, 6))}
}
\description{
This function creates a template for the definition of multistage designs as required by the estimation function (in multistage design cases). The defines multistage design is then handed over to the function\code{tmt_mstdesign}. Essentially, these are the modules, rules and path sections. In the formula-based notation, it is also possible to state additional conditions (constraints) that can be found in the data and are reflected in the multistage design.
}
\examples{
#############################################################################
# create simple template
#############################################################################
formula = "start(start) += S1(B1,B2,B3) += S2(B4,B5,B6,B7)"
tmt_msttemplate(formula, full = TRUE, eval = TRUE)
tmt_msttemplate(formula, full = TRUE, eval = FALSE)

#############################################################################
# create complex template
#############################################################################

formula = "nativ(no,yes) ~ education(low,medium,heigh) ~ 
            CBM(3:6) += S1(B1,B2,B3) += S2(B4,B5,B6,B7)"
tmt_msttemplate(formula, full = TRUE, eval = TRUE)
tmt_msttemplate(formula, full = TRUE, eval = FALSE)

#############################################################################
# create template for the input as matrix
#############################################################################
tmt_msttemplate()
}
\author{
Jan Steinfeld
}
