% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/BinOutModelClass.R
\docType{class}
\name{BinOutModel}
\alias{BinOutModel}
\title{R6 class for fitting and making predictions for a single logistic regression with binary outcome B, P(B | PredVars)}
\format{An \code{\link{R6Class}} generator object}
\usage{
BinOutModel
}
\description{
This R6 class can request, store and manage the design matrix Xmat, as well as the binary outcome Bin for the
 logistic regression P(Bin|Xmat).
 Can also be used for converting data in wide format to long when requested,
 e.g., when pooling across binary indicators (fitting one pooled logistic regression model for several indicators)
 The class has methods that perform queries to data storage R6 class DatNet.sWsA to get appropriate data columns & row subsets
}
\details{
\itemize{
\item{cont.sVar.flag} - Is the original outcome variable continuous?
\item{bw.j} - Bin width (interval length) for an outcome that is a bin indicator of a discretized continous outcome.
\item{glmfitclass} - Controls which package will be used for performing model fits (\code{glm} or \code{speedglm}).
\item{bindat} - Pointer to an instance of \code{BinDat} class that contains the data.
}
}
\section{Methods}{

\describe{
  \item{\code{new(reg)}}{Uses \code{reg} R6 \code{\link{RegressionClass}} object to instantiate a new model for a
  logistic regression with binary outcome.}
  \item{\code{show()}}{Print information on outcome and predictor names used in this regression model}
  \item{\code{fit()}}{...}
  \item{\code{copy.fit()}}{...}
  \item{\code{predict()}}{...}
  \item{\code{copy.predict()}}{...}
  \item{\code{predictAeqa()}}{...}
}
}

\section{Active Bindings}{

\describe{
  \item{\code{getoutvarnm}}{...}
  \item{\code{getoutvarval}}{...}
  \item{\code{getsubset}}{...}
  \item{\code{getprobA1}}{...}
  \item{\code{getfit}}{...}
  \item{\code{wipe.alldat}}{...}
}
}
\keyword{R6}
\keyword{class}

