% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install.R
\name{install_tinytex}
\alias{install_tinytex}
\alias{uninstall_tinytex}
\alias{reinstall_tinytex}
\title{Install/Uninstall TinyTeX}
\usage{
install_tinytex(force = FALSE, dir = "auto", repository = "ctan", extra_packages = NULL)

uninstall_tinytex(force = FALSE, dir = texlive_root())

reinstall_tinytex(packages = TRUE, dir = texlive_root(), ...)
}
\arguments{
\item{force}{Whether to force to install (override) or uninstall TinyTeX.}

\item{dir}{The directory to install or uninstall TinyTeX (should not exist
unless \code{force = TRUE}).}

\item{repository}{The CTAN repository to be used. By default, a fast mirror
is automatically chosen. You can manually set one if the automatic mirror
is not really fast enough, e.g., if you are in China, you may consider
\code{'http://mirrors.tuna.tsinghua.edu.cn/CTAN/systems/texlive/tlnet'}.}

\item{extra_packages}{A character vector of extra LaTeX packages to be
installed.}

\item{packages}{Whether to reinstall all currently installed packages.}

\item{...}{Other arguments to be passed to \code{install_tinytex()} (note
that the \code{extra_packages} argument will be set to \code{tl_pkgs()} if
\code{packages = TRUE}).}
}
\description{
The function \code{install_tinytex()} downloads the installation script from
\url{https://github.com/yihui/tinytex} according to the platform (Unix or
Windows), and executes it to install TinyTeX (a custom LaTeX distribution
based on TeX Live). The function \code{uninstall_tinytex()} removes TinyTeX.
}
\references{
See the TinyTeX documentation (\url{https://yihui.name/tinytex/})
  for the default installation directories on different platforms.
}
