% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ops.R
\name{diff}
\alias{diff}
\alias{diff.tind}
\alias{diff.tdiff}
\title{Lagged Differences for \code{tind} and \code{tdiff} Objects}
\usage{
\method{diff}{tind}(x, lag = 1L, differences = 1L, ...)

\method{diff}{tdiff}(x, lag = 1L, differences = 1L, ...)
}
\arguments{
\item{x}{an object of \code{tind} class or \code{tdiff} class.}

\item{lag}{an integer value.}

\item{differences}{an integer value.}

\item{...}{(ignored) further arguments passed to or from other methods.}
}
\value{
An object of \code{tdiff} class, except for \code{x} argument
of \code{tind} class of type \code{"i"} or \code{"n"} (integer/numeric
indices), in which case an integer or numeric vector is returned.
}
\description{
\code{diff} method for \code{tind} and \code{tdiff} works in a standard way.
For all index types except for integer and numeric indices, differences
of time indices are retuned as objects of \code{tdiff} class.
}
\examples{
(nn <- sample(1:10))
(x <- today() + nn)
# all 3 should be the same
diff(x, 2, 2)
as.tdiff(diff(nn, 2, 2), "d")
diff(as.tdiff(nn, "d"), 2, 2)

}
\seealso{
\link{Ops}.
}
