% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/timmaModel1.R
\name{timmaModel1}
\alias{timmaModel1}
\title{Predicting drug sensitivity with binary drug-target interaction data using two.sided TIMMA model}
\usage{
timmaModel1(drug_target_profile, y_actual, loo = TRUE)
}
\arguments{
\item{drug_target_profile}{the drug-target interaction data. See \code{\link{timma}}.}

\item{y_actual}{a drug sensitivity vector.}

\item{loo}{a logical value indicating whether to use the leave-one-out cross-validation in the model
selection process. By default, loo = TRUE.}
}
\value{
A list containing the following components:
\item{dummy}{the predicted efficacy matrix}
\item{error}{the prediction errors}
\item{prediction}{predicted drug sensitivity}
The difference between \code{\link{timmaModel}} and \code{\link{timmaBinary}} is \code{\link{timmaModel}}
returns the predicted efficacy matrix of all possible target combinations while \code{\link{timmaBinary}}
not.
}
\description{
A function to predict the drug sensitivity with binary drug-target interaction data using the
two.sided TIMMA model
}
\examples{
data(tyner_interaction_binary)
data(tyner_sensitivity)
results<-timmaModel1(tyner_interaction_binary[, 1:6], tyner_sensitivity[,1])
}
\author{
Liye He \email{liye.he@helsinki.fi}
}

