% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/sffsBinary2.R
\name{sffsBinary2}
\alias{sffsBinary2}
\title{Model selection with filtered binary drug-target interaction data}
\usage{
sffsBinary2(profile_data, sens, sp = 1, max_k = 5, loo = TRUE,
  new_initial_list, verbosity = FALSE)
}
\arguments{
\item{profile_data}{drug-target interaction data which is a matrix with drugs as row indexes and targets
as column indexes.}

\item{sens}{a drug sensitivity vector.}

\item{sp}{an integer to specify the starting point for sequential forward floating search (sffs) search
algorithm to navigate the target set space. By default, sp = 1.}

\item{max_k}{an integer to sepcify the maximum number of targets that can be selected by the sffs
algorithm. By default, max_k = 5. In practice it should not be over than 10 as the number of target combinations will increase exponentially.}

\item{loo}{a logical value indicating whether to use the leave-one-out cross-validation in the model
selection process. By default, loo = TRUE.}

\item{new_initial_list}{a vector of the filtered targets indexes.}

\item{verbosity}{a boolean value to decide if the information should be displayed. If it is TRUE, the information
will be displayed while the model is running. Otherwise, the information will not be displayed. By default, it is
FALSE.}
}
\value{
A list containing the following components:
\item{timma}{a list contains: the predicted efficacy matrix, prediction error and predicted drug sensitivity}
\item{k_sel}{the indexes for selected targets}
}
\description{
A function to run sffs for model selection with filtered binary drug-target interaction data
}
\details{
The major difference between original and modified averaging method is the averaging methods for the case where the minimization and maximization rules are not simultaneously satisfied.
For example, for a queried target set there are supersets but not subsets in the training data, the original algorithm will take the prediction from these supersets data using the minimization rule.
However, the modified algorithm will further adjust the prediction using the average between such a prediction and 0.
}
\examples{
\dontrun{
data(tyner_interaction_binary)
data(tyner_sensitivity)
profile<-tyner_interaction_binary[,c(-1, -2, -5)]
num<-length(tyner_sensitivity[,1])
k_set<-rep(0, dim(profile)[2])
k_set[1]<-1
result<-sffsBinary2(profile, tyner_sensitivity[,1], new_initial_list = k_set, max_k=2)
}
}
\author{
Liye He \email{liye.he@helsinki.fi}
}

