% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solvedose_ph_alk.R
\name{solvedose_alk_once}
\alias{solvedose_alk_once}
\title{Apply `solvedose_alk` to a dataframe and create a new column with numeric dose}
\usage{
solvedose_alk_once(
  df,
  input_water = "defined_water",
  output_column = "dose_required",
  target_alk = NULL,
  chemical = NULL
)
}
\arguments{
\item{df}{a data frame containing a water class column, which has already been computed using
\code{\link{define_water_chain}}. The df may include a column with names for each of the chemicals being dosed.}

\item{input_water}{name of the column of water class data to be used as the input. Default is "defined_water".}

\item{output_column}{name of the output column storing doses in mg/L. Default is "dose_required".}

\item{target_alk}{set a goal for alkalinity using the function argument or a data frame column}

\item{chemical}{select the chemical to be used to reach the desired alkalinity using function argument or data frame column}
}
\value{
A data frame containing the original data frame and columns for target alkalinity, chemical dosed, and required chemical dose.
}
\description{
This function allows \code{\link{solvedose_alk}} to be added to a piped data frame.
Its output is a chemical dose in mg/L.
}
\details{
The data input comes from a `water` class column, initialized in \code{\link{define_water}} or \code{\link{balance_ions}}.

If the input data frame has column(s) named "target_alk" or "chemical", the function will use the column(s)
as function argument(s). If these columns aren't present, specify "target_alk" or "chemical" as function arguments.
The chemical names must match the chemical names as displayed in \code{\link{solvedose_alk}}.
To see which chemicals can be dosed, see \code{\link{solvedose_alk}}.

 For large datasets, using `fn_once` or `fn_chain` may take many minutes to run. These types of functions use the furrr package
 for the option to use parallel processing and speed things up. To initialize parallel processing, use
 `plan(multisession)` or `plan(multicore)` (depending on your operating system) prior to your piped code with the
 `fn_once` or `fn_chain` functions. Note, parallel processing is best used when your code block takes more than a minute to run,
 shorter run times will not benefit from parallel processing.
}
\examples{

library(purrr)
library(furrr)
library(tidyr)
library(dplyr)

example_df <- water_df \%>\%
  define_water_chain() \%>\%
  balance_ions_chain() \%>\%
  mutate(
    target_alk = 300,
    chemical = rep(c("naoh", "na2co3"), 6)
  ) \%>\%
  solvedose_alk_once()

# When the selected chemical can't raise the alkalinity, the dose_required will be NA
# Eg,soda ash can't bring the alkalinity to 100 when the water's alkalinity is already at 200.

example_df <- water_df \%>\%
  define_water_chain() \%>\%
  solvedose_alk_once(input_water = "defined_water", target_alk = 100, chemical = "na2co3")


example_df <- water_df \%>\%
  define_water_chain() \%>\%
  mutate(target_alk = seq(100, 210, 10)) \%>\%
  solvedose_alk_once(chemical = "na2co3")

\donttest{
# Initialize parallel processing
plan(multisession, workers = 2) # Remove the workers argument to use all available compute
example_df <- water_df \%>\%
  define_water_chain() \%>\%
  mutate(target_alk = seq(100, 210, 10)) \%>\%
  solvedose_alk_once(chemical = "na2co3")

# Optional: explicitly close multisession processing
plan(sequential)
}

}
\seealso{
\code{\link{solvedose_alk}}
}
