% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chemdose_dbp.R
\name{chemdose_dbp}
\alias{chemdose_dbp}
\title{Calculate DBP formation}
\source{
TTHMs, raw: U.S. EPA (2001) equation 5-131

HAAs, raw: U.S. EPA (2001) equation 5-134

TTHMs, treated: U.S. EPA (2001) equation 5-139

HAAs, treated: U.S. EPA (2001) equation 5-142

See references list at: \url{https://github.com/BrownandCaldwell-Public/tidywater/wiki/References}
}
\usage{
chemdose_dbp(
  water,
  cl2,
  time,
  treatment = "raw",
  cl_type = "chorine",
  location = "plant"
)
}
\arguments{
\item{water}{Source water object of class "water" created by \code{\link{define_water}}}

\item{cl2}{Applied chlorine dose (mg/L as Cl2). Model results are valid for doses between 1.51 and 33.55 mg/L.}

\item{time}{Reaction time (hours). Model results are valid for reaction times between 2 and 168 hours.}

\item{treatment}{Type of treatment applied to the water. Options include "raw" for no treatment (default), "coag" for
water that has been coagulated or softened, and "gac" for water that has been treated by granular activated carbon (GAC).
GAC treatment has also been used for estimating formation after membrane treatment with good results.}

\item{cl_type}{Type of chlorination applied, either "chlorine" (default) or "chloramine".}

\item{location}{Location for DBP formation, either in the "plant" (default), or in the distributions system, "ds".}
}
\value{
A water class object with predicted DBP concentrations.
}
\description{
\code{chemdose_dbp} calculates disinfection byproduct (DBP) formation based on the U.S. EPA's
Water Treatment Plant Model (U.S. EPA, 2001). Required arguments include an object of class "water"
created by \code{\link{define_water}} chlorine dose, type, reaction time, and treatment applied (if any).
The function also requires additional water quality parameters defined in \code{define_water}
including bromide, TOC, UV254, temperature, and pH.
}
\details{
The function will calculate haloacetic acids (HAA) as HAA5, and total trihalomethanes (TTHM).
Use \code{summarise_wq} to quickly tabulate the results.
}
\examples{
example_dbp <- suppressWarnings(define_water(8, 20, 66, toc = 4, uv254 = .2, br = 50)) \%>\%
  chemdose_dbp(cl2 = 2, time = 8)
example_dbp <- suppressWarnings(define_water(7.5, 20, 66, toc = 4, uv254 = .2, br = 50)) \%>\%
  chemdose_dbp(cl2 = 3, time = 168, treatment = "coag", location = "ds")

}
