% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_background_time.R
\name{sample_background_time}
\alias{sample_background_time}
\title{Sample background points for SDM analysis for points with a time point.}
\usage{
sample_background_time(
  data,
  raster,
  n_per_time_step,
  coords = NULL,
  time_col = "time",
  lubridate_fun = c,
  method = "random",
  class_label = "background",
  return_pres = TRUE,
  time_buffer = 0
)
}
\arguments{
\item{data}{An \code{\link[sf:sf]{sf::sf}} data frame, or a data frame with coordinate
variables. These can be defined in \code{coords}, unless they have standard
names (see details below).}

\item{raster}{the \link[terra:SpatRaster-class]{terra::SpatRaster}, \code{stars} or \link[terra:SpatRaster-class]{terra::SpatRasterDataset}
from which cells will be sampled. If a \link[terra:SpatRaster-class]{terra::SpatRasterDataset}, the
first dataset will be used to define which cells are valid, and which are
NAs.}

\item{n_per_time_step}{number of background points to sample for each time
step (i.e. a vector of length equal to the number of time steps in raster)}

\item{coords}{a vector of length two giving the names of the "x" and "y"
coordinates, as found in \code{data}. If left to NULL, the function will try to
guess the columns based on standard names \code{c("x", "y")}, \code{c("X","Y")},
\code{c("longitude", "latitude")}, or \code{c("lon", "lat")}}

\item{time_col}{The name of the column with time; if time is not a lubridate
object, use \code{lubridate_fun} to provide a function that can be used to
convert appropriately}

\item{lubridate_fun}{function to convert the time column into a lubridate
object}

\item{method}{sampling method. One of 'random', 'dist_max', or 'bias'.}

\item{class_label}{the label given to the sampled points. Defaults to
\code{background}}

\item{return_pres}{return presences together with background in a single
tibble}

\item{time_buffer}{the buffer on the time axis around presences that defines
their effect when sampling background with method 'max_dist'. If set to
zero, presences have an effect only on the time step to which they are
assigned in \code{raster}; if a positive value, it defines the number of days
before and after the date provided in the \code{time} column for which the
presence should be considered (e.g. 20 days means that a presence is
considered in all time steps equivalent to plus and minus twenty days from
its date).}
}
\value{
An object of class \link[tibble:tibble]{tibble::tibble}. If presences are returned, the
presence level is set as the reference (to match the expectations in the
\code{yardstick} package that considers the first level to be the event)
}
\description{
This function samples background points from a raster given a set of
presences. The locations returned as the center points of the sampled cells,
which can overlap with the presences (in contrast to pseudo-absences, see
\link{sample_pseudoabs_time}). The following methods are implemented:
\itemize{
\item 'random': background points randomly sampled from the region covered by the
raster (i.e. not NAs).
\item 'dist_max': background points randomly sampled from the unioned buffers
of 'dist_max' from presences (distances in 'm' for lonlat rasters, and in map
units for projected rasters). Using the union of buffers means that areas
that are in multiple buffers are not oversampled. This is also referred to as
"thickening".
\item 'bias': background points are sampled according to a surface representing
the biased sampling effort. Note that the surface for each time step is
normalised to sum to 1;use \code{n_per_time_step} to affect sampling effort within
each time step.
}
}
\details{
Note that the time axis of the raster should be in \code{POSIXct} or
\code{Date} format, or use `tstep="years"'. See \code{\link[terra:time]{terra::time()}} for details on
how to set the time axis.
}
