% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_member.R
\name{add_member}
\alias{add_member}
\alias{add_member.default}
\alias{add_member.tune_results}
\alias{add_member.workflow_set}
\title{Add best member of workflow to a simple ensemble}
\usage{
add_member(x, member, ...)

\method{add_member}{default}(x, member, ...)

\method{add_member}{tune_results}(x, member, metric = NULL, id = NULL, ...)

\method{add_member}{workflow_set}(x, member, metric = NULL, ...)
}
\arguments{
\item{x}{a \link{simple_ensemble} to which member(s) will be added}

\item{member}{a  \code{tune_results}, or a \code{\link[workflowsets:workflow_set]{workflowsets::workflow_set}}}

\item{...}{not used at the moment.}

\item{metric}{A character string (or NULL) for which metric to optimize.
If NULL, the first metric is used.}

\item{id}{the name to be given to this workflow in the \code{wflow_id} column.}
}
\value{
a \link{simple_ensemble} with additional member(s)
}
\description{
This function adds member(s) to a \code{\link[=simple_ensemble]{simple_ensemble()}} object, taking the
best member from each workflow provided. It is possible to pass individual
\code{tune_results} objects from a tuned \code{workflow}, or a
\code{\link[workflowsets:workflow_set]{workflowsets::workflow_set()}}.
}
