% Generated by roxygen2 (4.0.2): do not edit by hand
\name{unnest}
\alias{unnest}
\title{Unnest a list column.}
\usage{
unnest(data, col = NULL)
}
\arguments{
\item{data}{A data frame.}

\item{col}{Name of column that needs to be unnested.}
}
\description{
If you have a list-column, this makes each element of the list it's own
row.
}
\examples{
library(dplyr)
df <- data.frame(
  x = 1:3,
  y = c("a", "d,e,f", "g,h"),
  stringsAsFactors = FALSE
)
df \%>\%
  transform(y = strsplit(y, ",")) \%>\%
  unnest(y)

# You can also unnest lists
my_list <- lapply(split(subset(iris, select = -Species), iris$Species), "[", 1:2, )
unnest(my_list)
unnest(my_list, Species)
}

