% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labels.R
\name{reorder_x_axis_labels}
\alias{reorder_x_axis_labels}
\alias{reorder_y_axis_labels}
\alias{reorder_color_labels}
\title{Reorder axis or color labels}
\usage{
reorder_x_axis_labels(plot, ...)

reorder_y_axis_labels(plot, ...)

reorder_color_labels(plot, ...)
}
\arguments{
\item{plot}{A \code{tidyplot} generated with the function \code{tidyplot()}.}

\item{...}{Arguments passed on to \code{forcats::fct_relevel()}.}
}
\value{
A \code{tidyplot} object.
}
\description{
Reorder axis or color labels
}
\examples{
# Before adjustments
study |>
  tidyplot(x = treatment, y = score) |>
  add_data_points() |>
  add_mean_bar(alpha = 0.4) |>
  add_sem_errorbar()

# Reorder x-axis labels
study |>
  tidyplot(x = treatment, y = score) |>
  add_data_points() |>
  add_mean_bar(alpha = 0.4) |>
  add_sem_errorbar() |>
  reorder_x_axis_labels("D", "B", "A")

# Before adjustments
study |>
  tidyplot(x = score, y = treatment) |>
  add_data_points() |>
  add_mean_bar(alpha = 0.4) |>
  add_sem_errorbar()

# Reorder y-axis labels
study |>
  tidyplot(x = score, y = treatment) |>
  add_data_points() |>
  add_mean_bar(alpha = 0.4) |>
  add_sem_errorbar() |>
  reorder_y_axis_labels("D", "B", "A")

# Before adjustment
study |>
  tidyplot(x = group, y = score, color = dose) |>
  add_data_points() |>
  add_mean_bar(alpha = 0.4) |>
  add_sem_errorbar()

# Reorder color labels
study |>
  tidyplot(x = group, y = score, color = dose) |>
  add_data_points() |>
  add_mean_bar(alpha = 0.4) |>
  add_sem_errorbar() |>
  reorder_color_labels("low")

}
