% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{save_plot}
\alias{save_plot}
\title{Save plots to file}
\usage{
save_plot(
  plot = ggplot2::last_plot(),
  filename,
  width = NA,
  height = NA,
  units = c("mm", "cm", "in"),
  multiple_files = FALSE,
  bg = "transparent",
  ...
)
}
\arguments{
\item{plot}{Plot to save, defaults to last plot displayed.}

\item{filename}{File name to create on disk.}

\item{width, height}{Dimensions of the graphic device to save the plot.
Defaults to \code{NA}. In case of \code{NA}, the dimensions are inferred from the
incoming \code{plot} object (see Details).}

\item{units}{Units of length. Defaults to \code{"mm"}.}

\item{multiple_files}{Whether to save multiple pages as individual files.}

\item{bg}{Background colour. If \code{NULL}, uses the \code{plot.background} fill value
from the plot theme.}

\item{...}{Other arguments passed on to the graphics device function,
as specified by \code{device}.}
}
\value{
A \code{tidyplot} object.
}
\description{
This function takes a plot or list of plots and writes them to a (multipage) file.
}
\details{
\strong{Handling of file dimensions.}
Output file dimensions are determined according the the following precedence.
\enumerate{
\item The \code{width} and \code{height} arguments.
\item Dimensions inferred from the incoming \code{plot} object with absolute dimensions.
\item System default device dimensions.
}
}
\examples{
\dontshow{
.old_wd <- setwd(tempdir())
}
# Save plot to file
study \%>\%
  tidyplot(treatment, score) \%>\%
  add_data_points() \%>\%
  save_plot("single_plot.pdf")

# Save intermediate stages to file
study \%>\%
  tidyplot(x = treatment, y = score, color = treatment) \%>\%
  add_mean_bar(alpha = 0.4) \%>\%
  add_sem_errorbar() \%>\%
  add_data_points_beeswarm() \%>\%
  save_plot("before.pdf") \%>\%
  adjust_colors(colors_discrete_seaside) \%>\%
  save_plot("after.pdf")

\donttest{

# Save multipage PDF file
gene_expression \%>\%
  .[1:160,] \%>\%
  tidyplot(group, expression, color = sample_type) \%>\%
  add_data_points() \%>\%
  split_plot(by = external_gene_name, nrow = 2, ncol = 2) \%>\%
  save_plot("multipage_plot.pdf")

# Save multiple PDF files
gene_expression \%>\%
  .[1:160,] \%>\%
  tidyplot(group, expression, color = sample_type) \%>\%
  add_data_points() \%>\%
  split_plot(by = external_gene_name, nrow = 2, ncol = 2) \%>\%
  save_plot("plot.pdf", multiple_files = TRUE)

}
\dontshow{
setwd(.old_wd)
}

}
