% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add-general.R
\name{add_sem_ribbon}
\alias{add_sem_ribbon}
\alias{add_range_ribbon}
\alias{add_sd_ribbon}
\alias{add_ci95_ribbon}
\title{Add ribbon}
\usage{
add_sem_ribbon(plot, dodge_width = NULL, alpha = 0.4, color = NA, ...)

add_range_ribbon(plot, dodge_width = NULL, alpha = 0.4, color = NA, ...)

add_sd_ribbon(plot, dodge_width = NULL, alpha = 0.4, color = NA, ...)

add_ci95_ribbon(plot, dodge_width = NULL, alpha = 0.4, color = NA, ...)
}
\arguments{
\item{plot}{A \code{tidyplot} generated with the function \code{tidyplot()}.}

\item{dodge_width}{For adjusting the distance between grouped objects. Defaults
to \code{0.8} for plots with at least one discrete axis and \code{0} for plots with two
continuous axes.}

\item{alpha}{A \code{number} between \code{0} and \code{1} for the opacity of an object. A value of \code{0} is completely transparent, \code{1} is completely opaque.}

\item{color}{A hex color for the stroke color. For example, \code{"#FFFFFF"} for white.}

\item{...}{Arguments passed on to the \code{geom} function.}
}
\value{
A \code{tidyplot} object.
}
\description{
\itemize{
\item \code{add_sem_ribbon()} adds the standard error of mean.
\item \code{add_range_ribbon()} adds the range from smallest to largest value.
\item \code{add_sd_ribbon()} adds the standard deviation.
\item \code{add_ci95_ribbon()} adds the 95\% confidence interval.
}
}
\examples{
# Standard error of the mean
time_course \%>\%
  tidyplot(x = day, y = score, color = treatment) \%>\%
  add_mean_line() \%>\%
  add_sem_ribbon()

# Range from minimum to maximum value
time_course \%>\%
  tidyplot(x = day, y = score, color = treatment) \%>\%
  add_mean_line() \%>\%
  add_range_ribbon()

# Standard deviation
time_course \%>\%
  tidyplot(x = day, y = score, color = treatment) \%>\%
  add_mean_line() \%>\%
  add_sd_ribbon()

# 95\% confidence interval
time_course \%>\%
  tidyplot(x = day, y = score, color = treatment) \%>\%
  add_mean_line() \%>\%
  add_ci95_ribbon()

# Changing arguments: alpha
time_course \%>\%
  tidyplot(x = day, y = score, color = treatment) \%>\%
  add_mean_line() \%>\%
  add_sem_ribbon(alpha = 0.7)

}
