% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add-heatmap.R
\name{add_heatmap}
\alias{add_heatmap}
\title{Add heatmap}
\usage{
add_heatmap(
  plot,
  scale = c("none", "row", "column"),
  rotate_labels = 90,
  rasterize = FALSE,
  rasterize_dpi = 300,
  ...
)
}
\arguments{
\item{plot}{A \code{tidyplot} generated with the function \code{tidyplot()}.}

\item{scale}{Whether to compute row z scores for \code{"row"} or \code{"column"}. Defaults to \code{"none"}.}

\item{rotate_labels}{Degree to rotate the x axis labels. Defaults to \code{90}.}

\item{rasterize}{If \code{FALSE} (the default) the layer will be constructed of
vector shapes. If \code{TRUE} the layer will be rasterized to a pixel image. This can
be useful when plotting many individual objects (1,000 or more) compromises
the performance of the generated PDF file.}

\item{rasterize_dpi}{The resolution in dots per inch (dpi) used for rastering
the layer if \code{rasterize} is \code{TRUE}. The default is \code{300} dpi.}

\item{...}{Arguments passed on to the \code{geom} function.}
}
\value{
A \code{tidyplot} object.
}
\description{
Add heatmap
}
\details{
\itemize{
\item \code{add_heatmap()} supports rasterization. See examples and \href{https://jbengler.github.io/tidyplots/articles/Advanced-plotting.html#rasterization}{Advanced plotting}.
}
}
\examples{
climate \%>\%
  tidyplot(x = month, y = year, color = max_temperature) \%>\%
  add_heatmap()

# Calculate row-wise z score
climate \%>\%
  tidyplot(x = month, y = year, color = max_temperature) \%>\%
  add_heatmap(scale = "row")

# Calculate column-wise z score
climate \%>\%
  tidyplot(x = month, y = year, color = max_temperature) \%>\%
  add_heatmap(scale = "column")

# Rasterize heatmap
climate \%>\%
  tidyplot(x = month, y = year, color = max_temperature) \%>\%
  add_heatmap(rasterize = TRUE, rasterize_dpi = 20)

}
